var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import process from 'node:process';
import { program } from 'commander';
import pc from 'picocolors';
import { getVersion } from '../core/file/packageJsonParse.js';
import { handleError } from '../shared/errorHandle.js';
import { logger } from '../shared/logger.js';
import { runDefaultAction } from './actions/defaultAction.js';
import { runInitAction } from './actions/initAction.js';
import { runRemoteAction } from './actions/remoteAction.js';
import { runVersionAction } from './actions/versionAction.js';
export const run = () => __awaiter(void 0, void 0, void 0, function* () {
    try {
        program
            .description('Repomix - Pack your repository into a single AI-friendly file')
            .arguments('[directory]')
            .option('-v, --version', 'show version information')
            .option('-o, --output <file>', 'specify the output file name')
            .option('--include <patterns>', 'list of include patterns (comma-separated)')
            .option('-i, --ignore <patterns>', 'additional ignore patterns (comma-separated)')
            .option('-c, --config <path>', 'path to a custom config file')
            .option('--copy', 'copy generated output to system clipboard')
            .option('--top-files-len <number>', 'specify the number of top files to display', Number.parseInt)
            .option('--output-show-line-numbers', 'add line numbers to each line in the output')
            .option('--style <type>', 'specify the output style (plain, xml, markdown)')
            .option('--no-file-summary', 'disable file summary section output')
            .option('--no-directory-structure', 'disable directory structure section output')
            .option('--remove-comments', 'remove comments')
            .option('--remove-empty-lines', 'remove empty lines')
            .option('--verbose', 'enable verbose logging for detailed output')
            .option('--init', 'initialize a new repomix.config.json file')
            .option('--global', 'use global configuration (only applicable with --init)')
            .option('--remote <url>', 'process a remote Git repository')
            .option('--token-count-encoding <encoding>', 'specify token count encoding (e.g., o200k_base, cl100k_base)')
            .option('--remote-branch <name>', 'specify the remote branch name, tag, or commit hash (defaults to repository default branch)')
            .option('--no-security-check', 'disable security check')
            .action((directory = '.', options = {}) => executeAction(directory, process.cwd(), options));
        yield program.parseAsync(process.argv);
    }
    catch (error) {
        handleError(error);
    }
});
export const executeAction = (directory, cwd, options) => __awaiter(void 0, void 0, void 0, function* () {
    logger.setVerbose(options.verbose || false);
    if (options.version) {
        yield runVersionAction();
        return;
    }
    const version = yield getVersion();
    logger.log(pc.dim(`\n📦 Repomix v${version}\n`));
    if (options.init) {
        yield runInitAction(cwd, options.global || false);
        return;
    }
    if (options.remote) {
        yield runRemoteAction(options.remote, options);
        return;
    }
    yield runDefaultAction(directory, cwd, options);
});
//# sourceMappingURL=cliRun.js.map